<?php
require_once '../init.php';
header('Content-Type: application/json');

// Read input (JSON or POST)
$data = json_decode(file_get_contents('php://input'), true);

$crate_id = '';

if (isset($data['crate_id'])) {
    $crate_id = trim($data['crate_id']);
} elseif (isset($_POST['crate_id'])) {
    $crate_id = trim($_POST['crate_id']);
}

$response = ['success' => false, 'message' => '', 'data' => [], 'status' => 0];

if ($crate_id === '') {
    $response['message'] = 'Crate ID is required';
    echo json_encode($response);
    exit;
}

$crate_id = mysqli_real_escape_string($mycon, $crate_id);
$transaction_id = uniqid("TXN");
$today = date('Y-m-d H:i:s');


$sql_check = "SELECT order_id, `status`, crate_weight FROM dispatch_crate_mapping_tbl WHERE crate_id = '$crate_id' AND status = '0'";
$result = mysqli_query($mycon, $sql_check);

if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);

    $sql_update = "UPDATE dispatch_crate_mapping_tbl SET status  = '1' WHERE crate_id = '$crate_id'";
    $update_result = mysqli_query($mycon, $sql_update);
    
    $update_sql = "UPDATE crate_registation_tbl SET transaction_id = '$transaction_id', operation = 'Outward', status = 2, transaction_datetime = '$today' WHERE crate_id = '$crate_id'";
    mysqli_query($mycon, $update_sql);

    // Insert into crate_tracking_history
    $tracking_sql = "INSERT INTO crate_tracking_history (user_id, warehouse_id, crate_id, operation, transaction_id, transaction_date_time) VALUES ('$user_id', '$warehouse_id', '$crate_id', 'Outward', '$transaction_id', '$today')";
    mysqli_query($mycon, $tracking_sql);

    if ($update_result) {
        $response['success'] = true;
        $response['message'] = 'Crate Loaded Successfully';
        $response['data'] = [
            'crate_id' => $crate_id,
            'CrateStatus' => $row['status'],
            'CrateWeight' => $row['crate_weight']
        ];
    }
} else {
    $response['message'] = 'Invalid Crate OR This Crate is Already Loaded.';
}

echo json_encode($response);
