<?php
require_once '../init.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Something went wrong'];

error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $response['message'] = 'Invalid request method';
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit;
}

$input = json_decode(file_get_contents("php://input"), true);
$data = !empty($input) ? $input : $_POST;

function safe($con, $value) {
    return mysqli_real_escape_string($con, $value ?? '');
}

$user_id          = safe($mycon, $data['user_id'] ?? '');
$warehouse_id     = safe($mycon, $data['warehouse_id'] ?? '');
$invoice_no       = safe($mycon, $data['invoice_no'] ?? '');
$product_code     = safe($mycon, $data['product_code'] ?? '');
$issue            = (float)($data['issue'] ?? 0);
$qty_issue_remark = safe($mycon, $data['qty_issue_remark'] ?? '');
$UploadExcelId    = (int)($data['upload_excel_id'] ?? 0);

if (empty($user_id) || empty($UploadExcelId)) {
    $response['message'] = "Missing required fields (user_id or upload_excel_id)";
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit;
}

// --------------------------------------
// 1. Fetch current GRN, issue, and total qty + missing info
// --------------------------------------
$sql_check = "SELECT * FROM upload_excel WHERE id = '$UploadExcelId'";
$result = mysqli_query($mycon, $sql_check);

if (!$result || mysqli_num_rows($result) == 0) {
    $response['message'] = "Invalid upload_excel_id";
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit;
}

$row = mysqli_fetch_assoc($result);

$total_invoice_qty = (float)$row['qty'];
$total_grn_qty     = (float)$row['grn_rev_qty'];
$total_issue_qty   = (float)$row['issue'];

// fill missing values from upload_excel table
$warehouse_id = !empty($warehouse_id) ? $warehouse_id : $row['warehouse_id'];
$invoice_no   = !empty($invoice_no)   ? $invoice_no   : $row['invoice_no'];
$product_code = !empty($product_code) ? $product_code : $row['product_code'];

// --------------------------------------
// 2. Validate issue amount
// --------------------------------------
$new_total_issue = $total_issue_qty + $issue;

// optional check if you want to prevent issuing more than total qty
// if ($new_total_issue + $total_grn_qty > $total_invoice_qty) {
//     $response['message'] = "You cannot issue more than the available product quantity.";
//     echo json_encode($response, JSON_PRETTY_PRINT);
//     exit;
// }

// --------------------------------------
// 3. Update upload_excel table
// --------------------------------------
$sql_update = "
    UPDATE upload_excel 
    SET 
        grn_rev_qty = grn_rev_qty - $issue,
        issue = issue + $issue,
        qty_issue_remark = '$qty_issue_remark'
    WHERE id = '$UploadExcelId'
";

if (mysqli_query($mycon, $sql_update)) {

    if ($issue > 0) {

        $vehicle_gatepass = safe($mycon, $row['vehicle_gatepass'] ?? '');
        $lr_number        = safe($mycon, $row['lr_number'] ?? '');
        $lot_no           = safe($mycon, $row['lot_no'] ?? '');
        $grn_id           = safe($mycon, $row['grn_id'] ?? '');
        $batchcode        = safe($mycon, $row['batchcode'] ?? '');

        $sql2 = "INSERT INTO reversal_refunding_discrepancy_product (user_id, warehouse_id, vehicle_gatepass, lr_number, invoice_no, total_qty, product_code, created_on, upload_excel_id, lot_no, issue_remark, issue_qty, returned_from_process, product_issue_status, grn_id, batchcode) VALUES ('$user_id', '$warehouse_id', '$vehicle_gatepass', '$lr_number', '$invoice_no', '$total_invoice_qty', '$product_code', NOW(), '$UploadExcelId', '$lot_no', '$qty_issue_remark', '$issue', 2, '4', '$grn_id', '$batchcode')";
        mysqli_query($mycon, $sql2);
    }

    $response = [
        'success' => true,
        'message' => 'Data updated successfully'
    ];
} else {
    $response['message'] = 'Database update error: ' . mysqli_error($mycon);
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
