<?php
require_once '../init.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Something went wrong'];

// Enable error display for debugging (you can disable later)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $response['message'] = 'Invalid request method';
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit;
}

// Read raw JSON input if available (for Flutter)
$input = json_decode(file_get_contents("php://input"), true);

// If JSON input exists, use it; otherwise fallback to $_POST
$data = !empty($input) ? $input : $_POST;

// Sanitize input safely
function safe($mycon, $value) {
    return mysqli_real_escape_string($mycon, $value ?? '');
}


$grn_no     = time();
$batchcode  = 'Batch/' . time();
$lotno      = 'LOT/' . time();
$receiving_date_time= date('Y-m-d H:i:s');

$user_id            = safe($mycon, $data['user_id'] ?? '');
$warehouse_id       = safe($mycon, $data['warehouse_id'] ?? '');
$vehicle_gatepass   = safe($mycon, $data['vehicle_gatepass'] ?? '');
$lrno               = safe($mycon, $data['lrno'] ?? '');
$invoice_no         = safe($mycon, $data['invoice_no'] ?? '');
$product_code       = safe($mycon, $data['product_code'] ?? '');
$qty                = (float)($data['qty'] ?? 0);
$invoice_qty        = (float)($data['invoice_qty'] ?? 0);
$existing_grn_qty   = (float)($data['existing_grn_qty'] ?? 0);
$grn_rev_qty        = (float)($data['grn_rev_qty'] ?? 0);
$issue              = (float)($data['issue'] ?? 0);
$qty_issue_remark   = safe($mycon, $data['qty_issue_remark'] ?? '');

$putway_id          = safe($mycon, $data['putway_id'] ?? '');
$bar_code           = safe($mycon, $data['bar_code'] ?? '');
$location           = safe($mycon, $data['location'] ?? '');
$product_color      = safe($mycon, $data['product_color'] ?? '');
$store              = safe($mycon, $data['store'] ?? '');
$area               = safe($mycon, $data['area'] ?? '');
$zone               = safe($mycon, $data['zone'] ?? '');
$mfg_date           = safe($mycon, $data['mfg_date'] ?? null);
$expiry_date        = safe($mycon, $data['expiry_date'] ?? null);
$no_of_boxes        = (int)($data['no_of_boxes'] ?? 0);
$no_of_boxes_issue  = (int)($data['no_of_boxes_issue'] ?? 0);
$vendor_name        = safe($mycon, $data['vendor_name'] ?? '');

// -------------------------------
// VALIDATION: Required fields
// -------------------------------
if (empty($user_id) || empty($warehouse_id) || empty($invoice_no) || empty($product_code)) {
    $response['message'] = "Missing required fields";
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit;
}

// -------------------------------
// VALIDATION: GRN qty check
// -------------------------------
if ($qty > $invoice_qty) {
    $response['message'] = "You don't have qty to do the GRN";
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit;
}

// -------------------------------
// INSERT INTO upload_excel TABLE
// -------------------------------
$sql = "INSERT INTO upload_excel (user_id, warehouse_id, product_code, invoice_qty, grn_rev_qty, no_of_boxes, issue, no_of_boxes_issue, qty_issue_remark, invoice_no, lrno, qty, vehicle_gatepass, lotno, batchcode, receiving_date_time, vendor_name, grn_id, is_generated, is_confirm) VALUES ('$user_id', '$warehouse_id', '$product_code', '$invoice_qty', '$grn_rev_qty', '$no_of_boxes', '$issue', '$no_of_boxes_issue', '$qty_issue_remark', '$invoice_no', '$lrno', '$qty','$vehicle_gatepass', '$lotno', '$batchcode', '$receiving_date_time', '$vendor_name', '$grn_no', '3', '1')";

if (mysqli_query($mycon, $sql)) {
    $upload_excel_id = mysqli_insert_id($mycon);

    // -------------------------------
    // INSERT INTO discrepancy TABLE if issue > 0
    // -------------------------------
    if ($issue > 0) {
        $discrepancy_sql = "INSERT INTO reversal_refunding_discrepancy_product (user_id, warehouse_id, vehicle_gatepass, lr_number, invoice_no, total_qty, product_code, upload_excel_id, lot_no, issue_remark, issue_qty, returned_from_process, grn_id, settlement_qty, batchcode) VALUES ('$user_id', '$warehouse_id', '$vehicle_gatepass', '$lrno', '$invoice_no', '$qty', '$product_code', '$upload_excel_id', '$lotno', '$qty_issue_remark', '$issue', 2, '$grn_no', 0, '$batchcode')";
        mysqli_query($mycon, $discrepancy_sql);
    }

    // -------------------------------
    // PENDING CHALLAN QTY
    // -------------------------------
    $pending_challan_qty = max(0, $invoice_qty - ($existing_grn_qty + $grn_rev_qty + $qty));

    $response = [
        'success' => true,
        'message' => 'Data inserted successfully',
        'data' => [
            'pending_challan_qty' => $pending_challan_qty,
            'lotno' => $lotno,
            'batchcode' => $batchcode,
            'grn_no' => $grn_no,
            'receiving_date_time' => $receiving_date_time
        ]
    ];
} else {
    $response['message'] = 'Database insert error: ' . mysqli_error($mycon);
}

// Output JSON
echo json_encode($response, JSON_PRETTY_PRINT);
?>
