<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$po_no = '';
$warehouse_id = '';

if (isset($data['po_no'])) {
    $po_no = trim($data['po_no']);
} elseif (isset($_POST['po_no'])) {
    $po_no = trim($_POST['po_no']);
}

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($po_no === '') {
    $response['message'] = 'PO No is required';
    echo json_encode($response);
    exit;
}

if ($warehouse_id === '') {
    $response['message'] = 'Warehouse ID is required';
    echo json_encode($response);
    exit;
}

$po_no = mysqli_real_escape_string($mycon, $po_no);
$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

$sql_check = "
SELECT 
    pm.product_code, 
    mm.`desc` AS product_desc, 
    pm.qty, 
    pd.po_no
FROM po_material pm
LEFT JOIN material_master mm 
    ON CONVERT(mm.part_no USING utf8mb4) COLLATE utf8mb4_unicode_ci = 
       CONVERT(pm.product_code USING utf8mb4) COLLATE utf8mb4_unicode_ci
LEFT JOIN po_details pd ON pd.id = pm.po_id
WHERE pd.po_no = '$po_no'
";

$result = mysqli_query($mycon, $sql_check);

if ($result && mysqli_num_rows($result) > 0) {
    $products = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $products[] = [
            'PO No'          => $row['po_no'],
            'Product Code'   => $row['product_code'],
            'Product Desc'   => $row['product_desc'],
            'PO Product Qty' => (float)$row['qty']
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Purchase Order Products Found';
    $response['data'] = $products;
} else {
    $response['message'] = 'No products found for this PO or Warehouse';
}

echo json_encode($response);
?>
