<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo "❌ No data received!";
    exit;
}

/* =====================================================
   FUNCTION: Generate Challan No (Sequential)
===================================================== */
function generateCustomChallanNo($mycon)
{
    $result = mysqli_query($mycon, "SELECT challan_no FROM vendor_challan_tbl ORDER BY id DESC LIMIT 1");
    $row = mysqli_fetch_assoc($result);

    if ($row && preg_match("/CH-\d{4}-(\d+)/", $row['challan_no'], $matches)) {
        $lastNo = intval($matches[1]);
        $newNo = str_pad($lastNo + 1, 4, "0", STR_PAD_LEFT);
    } else {
        $newNo = "0001"; // first challan
    }
    return "CH-" . date("Y") . "-" . $newNo;
}

/* =====================================================
   FUNCTION: Get Actual po_no using ID
===================================================== */
function getPONumber($mycon, $po_id)
{
    $sql = "SELECT po_no FROM po_details WHERE id='$po_id' LIMIT 1";
    $res = mysqli_query($mycon, $sql);
    $row = mysqli_fetch_assoc($res);
    return $row ? $row['po_no'] : null;
}

/* =====================================================
   FUNCTION: Get Available Qty (Based on Issued Challans)
===================================================== */
function getAvailableQty($mycon, $po_id, $code)
{
    // Get total PO qty
    $sql_po = "SELECT qty FROM po_material WHERE po_id = '$po_id' AND product_code = '$code' LIMIT 1";
    $res_po = mysqli_query($mycon, $sql_po);
    $row_po = mysqli_fetch_assoc($res_po);
    $po_qty = $row_po ? (int)$row_po['qty'] : 0;

    // Get total already issued qty from challans
    $sql_challan = "SELECT SUM(qty) as issued FROM vendor_challan_tbl 
                    WHERE po_no = (SELECT po_no FROM po_details WHERE id='$po_id' LIMIT 1)
                    AND product_code = '$code'";
    $res_ch = mysqli_query($mycon, $sql_challan);
    $row_ch = mysqli_fetch_assoc($res_ch);
    $issued = $row_ch && $row_ch['issued'] ? (int)$row_ch['issued'] : 0;

    // Available = total PO - already issued
    $available = $po_qty - $issued;
    return max($available, 0);
}

/* =====================================================
   MULTIPLE ROWS CASE
===================================================== */
if (isset($data[0])) {
    // Group by PO id
    $grouped = [];
    foreach ($data as $row) {
        $grouped[$row['po_no']][] = $row;
    }

    foreach ($grouped as $po_id_for_challan => $rows) {
        $po_id_for_challan = mysqli_real_escape_string($mycon, $po_id_for_challan);

        // ✅ Convert ID to actual po_no
        $po_num = getPONumber($mycon, $po_id_for_challan);

        if (!$po_num) {
            echo "❌ Invalid PO ID: $po_id_for_challan";
            exit;
        }

        foreach ($rows as $row) {
            $challan_no = mysqli_real_escape_string($mycon, $row['challan_no']);

            // ✅ If challan no empty → generate new
            if (empty($challan_no)) {
                $challan_no = generateCustomChallanNo($mycon);
            }

            $po_id  = mysqli_real_escape_string($mycon, $row['po_no']); // id aa rahi hai
            $code   = mysqli_real_escape_string($mycon, $row['product_code']);
            $po_qty = mysqli_real_escape_string($mycon, $row['po_qty']);
            $desc   = mysqli_real_escape_string($mycon, $row['product_desc']);
            $uom    = mysqli_real_escape_string($mycon, $row['uom']);
            $moq    = mysqli_real_escape_string($mycon, $row['moq']);
            $color  = mysqli_real_escape_string($mycon, $row['product_color']);
            $qty    = (int)$row['qty'];

            if ($qty <= 0) continue;

            // ✅ Check available stock based on issued challans
            $available = getAvailableQty($mycon, $po_id, $code);
            if ($qty > $available) {
                echo "❌ Not enough available quantity for Product $code! Available: $available, Requested: $qty";
                exit;
            }

            // ✅ Prevent exceeding PO Qty
            if ($qty > $po_qty) {
                echo "❌ Qty cannot be greater than PO Qty ($po_qty)!";
                exit;
            }

            // ✅ Insert challan row with po_no
            $sql = "INSERT INTO vendor_challan_tbl 
                    (user_id, warehouse_id, vendor_code, challan_no, po_no, product_code, po_qty, product_desc, uom, moq, product_color, qty) 
                    VALUES 
                    ('$userid', '$warehouse_id', '$vendor_code', '$challan_no', '$po_num', '$code', '$po_qty', '$desc', '$uom', '$moq', '$color', '$qty')";
            if (!mysqli_query($mycon, $sql)) {
                echo "❌ Insert failed: " . mysqli_error($mycon);
                exit;
            }

            // ❌ Do NOT update po_material qty anymore
        }
    }

    echo "✅ All rows saved successfully.";

/* =====================================================
   SINGLE ROW CASE
===================================================== */
} else {
    $po_id  = mysqli_real_escape_string($mycon, $data['po_no']); // id aa rahi hai
    $po_num = getPONumber($mycon, $po_id);

    if (!$po_num) {
        echo "❌ Invalid PO ID!";
        exit;
    }

    $challan_no = mysqli_real_escape_string($mycon, $data['challan_no']);
    if (empty($challan_no)) {
        $challan_no = generateCustomChallanNo($mycon); // fallback
    }

    $code   = mysqli_real_escape_string($mycon, $data['product_code']);
    $po_qty = mysqli_real_escape_string($mycon, $data['po_qty']);
    $desc   = mysqli_real_escape_string($mycon, $data['product_desc']);
    $uom    = mysqli_real_escape_string($mycon, $data['uom']);
    $moq    = mysqli_real_escape_string($mycon, $data['moq']);
    $color  = mysqli_real_escape_string($mycon, $data['product_color']);
    $qty    = (int)$data['qty'];

    if ($qty <= 0) {
        echo "❌ Invalid Qty!";
        exit;
    }

    // ✅ Check available stock based on issued challans
    $available = getAvailableQty($mycon, $po_id, $code);
    if ($qty > $available) {
        echo "❌ Not enough available quantity for Product $code! Available: $available, Requested: $qty";
        exit;
    }

    // ✅ Prevent exceeding PO Qty
    if ($qty > $po_qty) {
        echo "❌ Qty cannot be greater than PO Qty ($po_qty)!";
        exit;
    }

    // ✅ Insert challan row with po_no
    $sql = "INSERT INTO vendor_challan_tbl 
            (user_id, warehouse_id, vendor_code, challan_no, po_no, product_code, po_qty, product_desc, uom, moq, product_color, qty) 
            VALUES 
            ('$userid', '$warehouse_id', '$vendor_code', '$challan_no', '$po_num', '$code', '$po_qty', '$desc', '$uom', '$moq', '$color', '$qty')";
    if (!mysqli_query($mycon, $sql)) {
        echo "❌ Insert failed: " . mysqli_error($mycon);
        exit;
    }

    // ❌ Do NOT update po_material qty anymore

    echo "✅ Row saved successfully with Challan No: $challan_no";
}
?>
