<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo "❌ No data received!";
    exit;
}

// ✅ Function: generate new challan number
function generateCustomChallanNo($mycon) {
    $result = mysqli_query($mycon, "SELECT challan_no FROM vendor_challan_tbl ORDER BY id DESC LIMIT 1");
    $row = mysqli_fetch_assoc($result);

    if ($row && preg_match("/CH-\d{4}-(\d+)/", $row['challan_no'], $matches)) {
        $lastNo = intval($matches[1]);
        $newNo = str_pad($lastNo + 1, 4, "0", STR_PAD_LEFT);
    } else {
        $newNo = "0001"; // first challan
    }
    return "CH-" . date("Y") . "-" . $newNo;
}

// ✅ Function: get challan if already exists for PO
function getChallanForPO($mycon, $po_no) {
    $sql = "SELECT challan_no FROM vendor_challan_tbl WHERE po_no = '$po_no' LIMIT 1";
    $res = mysqli_query($mycon, $sql);
    $row = mysqli_fetch_assoc($res);
    return $row ? $row['challan_no'] : null;
}

// ✅ Function: check available qty
function getAvailableQty($mycon, $po_no, $code) {
    $sql = "SELECT qty FROM po_material WHERE po_id = '$po_no' AND product_code = '$code' LIMIT 1";
    $res = mysqli_query($mycon, $sql);
    $row = mysqli_fetch_assoc($res);
    return $row ? (int)$row['qty'] : 0;
}

// Handle multiple rows
if (isset($data[0])) {
    // Group by PO no
    $grouped = [];
    foreach ($data as $row) {
        $grouped[$row['po_no']][] = $row;
    }

    foreach ($grouped as $po_no_for_challan => $rows) {
        $po_no_for_challan = mysqli_real_escape_string($mycon, $po_no_for_challan);

        // ✅ Check if challan exists for this PO
        $existingChallan = getChallanForPO($mycon, $po_no_for_challan);
        if ($existingChallan) {
            $challan_no = $existingChallan;
        } else {
            $challan_no = generateCustomChallanNo($mycon);
        }

        foreach ($rows as $row) {
            $po_no  = mysqli_real_escape_string($mycon, $row['po_no']);
            $code   = mysqli_real_escape_string($mycon, $row['product_code']);
            $po_qty = mysqli_real_escape_string($mycon, $row['po_qty']);
            $desc   = mysqli_real_escape_string($mycon, $row['product_desc']);
            $uom    = mysqli_real_escape_string($mycon, $row['uom']);
            $moq    = mysqli_real_escape_string($mycon, $row['moq']);
            $color  = mysqli_real_escape_string($mycon, $row['product_color']);
            $qty    = (int)$row['qty'];

            if ($qty <= 0) continue;

            // ✅ Check available stock
            $available = getAvailableQty($mycon, $po_no, $code);
            if ($qty > $available) {
                echo "❌ Not enough stock for Product $code! Available: $available, Requested: $qty";
                exit;
            }

            // Insert challan row
            $sql = "INSERT INTO vendor_challan_tbl 
                    (user_id, warehouse_id, vendor_code, challan_no, po_no, product_code, po_qty, product_desc, uom, moq, product_color, qty) 
                    VALUES 
                    ('$userid', '$warehouse_id', '$vendor_code', '$challan_no', '$po_no', '$code', '$po_qty', '$desc', '$uom', '$moq', '$color', '$qty')";
            mysqli_query($mycon, $sql);

            // ✅ Update stock without negative
            $updateSQL = "UPDATE po_material 
                          SET qty = GREATEST(qty - $qty, 0) 
                          WHERE po_id = '$po_no' AND product_code = '$code'";
            mysqli_query($mycon, $updateSQL);
        }
    }

    echo "✅ All rows saved successfully.";

} else {
    // Single row case
    $po_no  = mysqli_real_escape_string($mycon, $data['po_no']);
    $code   = mysqli_real_escape_string($mycon, $data['product_code']);
    $po_qty = mysqli_real_escape_string($mycon, $data['po_qty']);
    $desc   = mysqli_real_escape_string($mycon, $data['product_desc']);
    $uom    = mysqli_real_escape_string($mycon, $data['uom']);
    $moq    = mysqli_real_escape_string($mycon, $data['moq']);
    $color  = mysqli_real_escape_string($mycon, $data['product_color']);
    $qty    = (int)$data['qty'];

    if ($qty > 0) {
        // ✅ Check if challan exists for this PO
        $existingChallan = getChallanForPO($mycon, $po_no);
        if ($existingChallan) {
            $challan_no = $existingChallan;
        } else {
            $challan_no = generateCustomChallanNo($mycon);
        }

        // ✅ Check available stock
        $available = getAvailableQty($mycon, $po_no, $code);
        if ($qty > $available) {
            echo "❌ Not enough stock for Product $code! Available: $available, Requested: $qty";
            exit;
        }

        // Insert challan row
        $sql = "INSERT INTO vendor_challan_tbl 
                (user_id, warehouse_id, vendor_code, challan_no, po_no, product_code, po_qty, product_desc, uom, moq, product_color, qty) 
                VALUES 
                ('$userid', '$warehouse_id', '$vendor_code', '$challan_no', '$po_no', '$code', '$po_qty', '$desc', '$uom', '$moq', '$color', '$qty')";
        mysqli_query($mycon, $sql);

        // ✅ Update stock
        $updateSQL = "UPDATE po_material 
                      SET qty = GREATEST(qty - $qty, 0) 
                      WHERE po_id = '$po_no' AND product_code = '$code'";
        mysqli_query($mycon, $updateSQL);

        echo "✅ Row saved successfully with Challan No: $challan_no";
    } else {
        echo "❌ Invalid Qty!";
    }
}
?>
