<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
	header('location: ../index.php');
}

function check_pro_alreadyinserted($mycon, $order_id)
{
	$sql_query = "SELECT product_code FROM packed_quantity_data WHERE order_id='" . $order_id . "' group by product_code";
	$result = mysqli_query($mycon, $sql_query);
	$count = mysqli_num_rows($result);
	return $count;
}

function check_pod_dt($mycon, $order_id)
{
	$sql_query = "SELECT pod_dt FROM pod_mngt WHERE order_id='" . $order_id . "'";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {
		while ($row = mysqli_fetch_assoc($result)) {
			$pod_dt = $row['pod_dt'];
		}

		return $pod_dt;
	}
}


function get_is_vehicle_out($mycon, $dispatch_id)
{
	$sql_query = "SELECT scd_id FROM dispatch_log WHERE id='" . $dispatch_id . "' LIMIT 0, 1";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {
		while ($row = mysqli_fetch_assoc($result)) {
			$scd_id = $row['scd_id'];
			$sql_query1 = "SELECT id FROM security_check_details WHERE id='" . $scd_id . "' AND in_out = 0";
			$result1 = mysqli_query($mycon, $sql_query1);
			if (mysqli_num_rows($result1) > 0) {
				$vehicle_out = mysqli_num_rows($result1);
			} else {
				$vehicle_out = 0;
			}
		}
	}
	if ($vehicle_out != '' || $vehicle_out != 0) {
		$vehicle_out1 = $vehicle_out;
	} else {
		$vehicle_out1 = 0;
	}
	return $vehicle_out1;
}

function get_transporter_name($mycon, $order_id)
{
	$sql_query = "SELECT transporter_name FROM packed_quantity_data where order_id='" . $order_id . "' group by transporter_name, order_id LIMIT 0, 1";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {
		while ($row = mysqli_fetch_assoc($result)) {
			$transporter_name = $row['transporter_name'];
		}

		return $transporter_name;
	}
}


function get_dispatch_id($mycon, $order_id)
{
	$sql_query = "SELECT dispatched_auto_id FROM packed_quantity_data where order_id='" . $order_id . "' group by dispatched_auto_id, order_id LIMIT 0, 1";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {
		while ($row = mysqli_fetch_assoc($result)) {
			$dispatched_id = $row['dispatched_auto_id'];
		}

		return $dispatched_id;
	}
}

function get_vehicle_no($mycon, $order_id)
{
	$sql_query = "SELECT vehicle_number FROM packed_quantity_data where order_id='" . $order_id . "' group by vehicle_number, order_id LIMIT 0, 1";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {
		while ($row = mysqli_fetch_assoc($result)) {
			$vehicle_number = $row['vehicle_number'];
		}

		return $vehicle_number;
	}
}

function get_dispatched_dt($mycon, $order_id)
{
	$sql_query = "SELECT dispatched_at FROM packed_quantity_data where order_id='" . $order_id . "' group by order_id LIMIT 0, 1";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {
		while ($row = mysqli_fetch_assoc($result)) {
			$dispatched_dt = $row['dispatched_at'];
		}

		return $dispatched_dt;
	}
}

function check_picking_count($mycon, $order_id)
{
	$sql_query = "SELECT * FROM picklist_generation WHERE order_id='" . $order_id . "' ";
	$result = mysqli_query($mycon, $sql_query);
	$count = mysqli_num_rows($result);
	return $count;
}

function get_total_pro_count($mycon, $order_id)
{
	$sql_query = "SELECT sum(qty) as total FROM order_material WHERE order_id='" . $order_id . "' ";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {

		while ($row = mysqli_fetch_assoc($result)) {
			$total = $row['total'];
		}

		return $total;
	}
}

function get_pod_details($order_id, $mycon)
{
	$data = array();
	$sql_query = "SELECT * FROM `pod_mngt` WHERE order_id='" . $order_id . "'";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {

		$row = mysqli_fetch_assoc($result);
		$data = $row;
		return $data;
	}
}


// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
	$sql_query = "SELECT order_id,ref_number,invoice_number,order_type,order_date,customer_code,s_contact_person_name,s_area,s_location,delivery_date,is_podConfirmed FROM `order_management` WHERE submit_status=1 " . $srcitem . " " . $srcfrom . " " . $role_item . " AND is_plan=0  AND order_status != 1	 order by order_id DESC";
	$result = mysqli_query($mycon, $sql_query);
	return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
	$sql_query = "SELECT order_id,ref_number,invoice_number,order_type,order_date,customer_code,s_contact_person_name,s_area,s_location,delivery_date,is_podConfirmed FROM `order_management` WHERE submit_status=1" . $role_item . " AND is_plan=0  AND order_status != 1	";
	$result = mysqli_query($mycon, $sql_query);
	return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

	if (isset($_POST["page"])) {
		$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
		if (!is_numeric($page_number)) {
			die('Invalid page number!');
		} //incase of invalid page number
	} else {
		$page_number = 1; //if there's no page number, set it to 1
	}

	//Advance Search
	$startHour = "00:00:00";
	$endHour = "23:55:55";


	if ($_POST['item'] == 'order_id') {
		$srcitem = " AND order_id = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'order_type') {
		$srcitem = " AND order_type = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'order_date') {
		$srcitem = " AND order_date = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'sales_delivery_number') {
		$srcitem = " AND ref_number = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'invoice_number') {
		$srcitem = " AND invoice_number LIKE '%" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'customer_code') {
		$srcitem = " AND customer_code = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'customer_name') {
		$srcitem = " AND s_contact_person_name LIKE '%" . trim($_POST['colunmData']) . "%'";
	} else if ($_POST['item'] == 'shipping_address') {
		$srcitem = " AND s_address LIKE '%" . trim($_POST['colunmData']) . "%'";
	} else if ($_POST['item'] == 'is_podConfirmed') {
		$podConfirmed = trim($_POST['colunmData']);
		if ($podConfirmed == 'pending') {
			$is_podConfirmed = 0;
		} else if ($podConfirmed == 'confirmed') {
			$is_podConfirmed = 1;
		} else {
			$is_podConfirmed = '';
		}
		$srcitem = " AND is_podConfirmed = '" . $is_podConfirmed . "'";
	} else if ($_POST['item'] == 'all') {
		$srcitem = "";
	} else if ($_POST['item'] == 'all') {
		$srcitem = "";
	}

	if ($_POST['todt'] != '') {
		$srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
	} else {
		$srcfrom = '';
	}
	//echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
?>
	<p class="details_table">
		<?php
		if ($_POST['item'] == '') {
			$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
			if ($is_defaultshowEntries > 20) {
				$defaultshowEntries = 20;
			} else {
				$defaultshowEntries = $is_defaultshowEntries;
			}
		?>
			<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
		<?php } else { ?>
			<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
		<?php } ?>
	</p>
	<div style="overflow-x: scroll;">
		<table class="table table-striped table-bordered table-hover" id="sample_3">
			<thead>
				<tr class="poke">

					<th>Order Id</th>
					<th>Sales <br />Delivery <br />Number </th>
					<th>Invoice / Challan Number</th>
					<th>Order Type</th>
					<th>Order Date</th>
					<!-- <th>Order Delivery Date</th> -->
					<th>Customer <br />Code</th>
					<th>Customer <br />Name</th>
					<th>Kitchen</th>
					<th>Location</th>
					<th>No.of <br />Product</th>
					<th>Vehicle No.</th>
					<th>Transporter</th>
					<th>Dispatched <br />Date</th>
					<th>POD <br />Date & Time</th>
					<th>POD <br />Status</th>
					<th style="padding: 0 20px 10px 20px;">POD Attachment </th>
					<th>POD Summary</th>
				</tr>
			</thead>
			<tbody>

				<?php
				//get total number of records from database for pagination
				$i = 1;
				$sql_query = "SELECT order_id,ref_number,invoice_number,order_type,order_date,customer_code,s_contact_person_name,s_area,s_location,delivery_date,is_podConfirmed FROM `order_management` WHERE submit_status=1 AND is_dispatched = 1 " . $srcitem . " " . $srcfrom . " " . $role_item . " AND is_plan=0  AND order_status != 1 order by order_id DESC";

				$result123 = mysqli_query($mycon, $sql_query);
				$get_total_rows = mysqli_num_rows($result123);
				$total_pages = ceil($get_total_rows / $item_per_page);


				//get starting position to fetch the records
				$page_position = (($page_number - 1) * $item_per_page);

				$sql_query_fetch = "SELECT order_id,ref_number,invoice_number,order_type,order_date,customer_code,s_contact_person_name,s_area,s_location,delivery_date,is_podConfirmed FROM `order_management` WHERE submit_status=1 AND is_dispatched = 1 " . $srcitem . " " . $srcfrom . " " . $role_item . " AND is_plan=0  AND order_status != 1 order by order_id DESC LIMIT $page_position, $item_per_page";


				$result_fetch = mysqli_query($mycon, $sql_query_fetch);
				//echo '<br/>' . $sql_query_fetch;
				//echo '<br/>' . $sql_query;
				if (mysqli_num_rows($result_fetch) > 0) {
					while ($row = mysqli_fetch_assoc($result_fetch)) {

						$pod_dt = check_pod_dt($mycon, $row['order_id']);
						$vehicle_no = get_vehicle_no($mycon, $row['order_id']);
						$dispatch_id = get_dispatch_id($mycon, $row['order_id']);
						$is_vehicle_out = get_is_vehicle_out($mycon, $dispatch_id);

						$pod_data = get_pod_details($row['order_id'], $mycon);
						// if($is_vehicle_out == 0){
				?>
						<tr>
							<td><?php echo $row['order_id']; ?> </td>
							<td><?php echo $row['ref_number']; ?> </td>
							<td><?php echo $row['invoice_number']; ?> </td>
							<td><?php
								if ($row['order_type'] == 0) {
									echo "Dispatch Order";
								} else {
									echo "Line Order";
								}
								?> </td>
							<td><?php echo $row['order_date']; ?> </td>
							<td><?php echo $row['customer_code']; ?> </td>
							<td><?php echo $row['s_contact_person_name']; ?> </td>
							<td><?php echo $row['s_area']; ?> </td>
							<td><?php echo $row['s_location']; ?> </td>
							<td><?php echo check_pro_alreadyinserted($mycon, $row['order_id']); ?></td>
							<td><?php echo $vehicle_no; ?></td>
							<td><?php echo get_transporter_name($mycon, $row['order_id']); ?></td>
							<td><?php echo get_dispatched_dt($mycon, $row['order_id']); ?></td>
							<td><?php echo $row['delivery_date']; ?></td>

							<td> <?php
									if ($row['is_podConfirmed'] == 1) {
										echo "POD Confirmed";
									} else {
										echo "Pending";
									}
									?> </td>

							<td>
								<?php if ($pod_dt != '') { ?>
									<a href="podUplloaded_attached.php?order_id=<?php echo $row['order_id']; ?>&">
										<span data-tooltip title="View Attachment" class="cursor"><i class="fa fa-eye" aria-hidden="true"></i>
										</span>
									</a>

									<div class="form-group form-md-line-input form-md-floating-label has-success">
										<?php $arr = explode(", ", $pod_data['uploaded_docs']);
										$i = 1;
										foreach ($arr as $val) {
											if ($val > 0) {
										?>
												<p><a href="uploads/<?php echo $val; ?>" target="_blank"><button class="btn btn-outline-dark btn-sm">Preview Document</button></a>
												</p>
										<?php $i++;
											}
										} ?>
									</div>

								<?php } else { ?>

									<a href="pod_form_view.php?order_id=<?php echo $row['order_id']; ?>">
										<span data-tooltip title="Upload your attachment" style="font-size:20px" class="cursor"><i class="fa fa-upload" aria-hidden="true"></i></span>
									</a>
								<?php } ?>
							</td>
							<td><?php if ($row['is_podConfirmed'] == '1') { ?><a href="pod_finalsheet.php?order_id=<?php echo $row['order_id']; ?>">
										<span data-tooltip title="summary" style="font-size:20px" class="cursor"><i class="fa fa-list-alt" aria-hidden="true"></i></span></a><?php } ?></td>
						</tr>

					<?php
					}
				} else {
					?>
					<tr>
						<td><?php echo 'No Record Found'; ?></td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
	<div align="center">
		<?php
		/* We call the pagination function here to generate Pagination link for us.
	    As you can see I have passed several parameters to the function. */
		echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
		?>
	</div>
<?php
}
?>
</div>