<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}


// function to get state name based on state id return state name
function get_state_name($mycon, $state_id)
{	
	if(!is_numeric($state_id)){
		return $state_id;
	}

	$sql_query = "SELECT state_name FROM `states` WHERE state_id='" . $state_id . "' ";
	$result = mysqli_query($mycon, $sql_query);
	$state_name = "";
	if (mysqli_num_rows($result) == 1) {
		$row = mysqli_fetch_assoc($result);
		$state_name = $row['state_name'];
	}
	return $state_name;
}

function get_city_name($mycon, $city_id)
{

	
	if(!is_numeric($city_id)){
		return $city_id;
	}

	$sql_query = "SELECT city_name FROM `cities` WHERE city_id='" . $city_id . "' ";
	$result = mysqli_query($mycon, $sql_query);
	$city_name = "";
	if (mysqli_num_rows($result) == 1) {
		$row = mysqli_fetch_assoc($result);
		$city_name = $row['city_name'];
	}
	return $city_name;
}

function get_country_id($mycon, $state_id){

	$sql_query = "SELECT country_id FROM `states` WHERE state_id='" . $state_id . "' limit 1 ";
	$result = mysqli_query($mycon, $sql_query);
	$country_id = "";
	if (mysqli_num_rows($result) == 1) {
		$row = mysqli_fetch_assoc($result);
		$country_id = $row['country_id'];
	}

	return $country_id;
}


function get_country_name($mycon, $country_id)
{
	
	if(!is_numeric($country_id)){
		return $country_id;
	}

	$sql_query = "SELECT country_name FROM `countries` WHERE country_id='" . $country_id . "' ";
	$result = mysqli_query($mycon, $sql_query);
	$country_name = "";
	if (mysqli_num_rows($result) == 1) {
		$row = mysqli_fetch_assoc($result);
		$country_name = $row['country_name'];
	}
	// echo "$country_name";
	return $country_name;
	
}



function get_Region_name($mycon, $region_id){
	$sql_query = "SELECT region FROM `region` WHERE id='" . $region_id . "' ";
	$result = mysqli_query($mycon, $sql_query);
	$country_name = "";
	if (mysqli_num_rows($result) == 1) {
		$row = mysqli_fetch_assoc($result);
		$country_name = $row['region'];
	}
	// echo "$country_name";
	return $country_name;

}



// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM `customer_details` WHERE customer_status != 0 " . $srcitem . " " . $srcfrom . " " . $role_item .  " AND uploaded_confirmed= '0' AND `type`= '2'";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM `customer_details` WHERE customer_status != 0 " . $role_item . " AND uploaded_confirmed= '0' AND `type`= 2";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

  if (isset($_POST["page"])) {
	$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
	if (!is_numeric($page_number)) {
	  die('Invalid page number!');
	} //incase of invalid page number
  } else {
	$page_number = 1; //if there's no page number, set it to 1
  }

//Advance Search
  $startHour = "00:00:00";
  $endHour = "23:55:55";
  if ($_POST['item'] == 'customer_code') {
	$srcitem = " AND customer_code = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'customer_name') {
	$srcitem = " AND customer_name LIKE '%" . trim($_POST['colunmData']) . "%'";
  } else if ($_POST['item'] == 'company_name') {
	$srcitem = " AND company_name = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'state') {
	$srcitem = " AND state = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'phone_no') {
	$srcitem = " AND phone_number = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'email') {
	$srcitem = " AND email = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'all') {
	$srcitem = "";
  }

  if ($_POST['todt'] != '') {
	$srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
  } else {
	$srcfrom = '';
  }
//Fetch data from role wised
//  if ($userdata['role'] == '2' || $userdata['role'] == '3') {
//	$user_location = $userdata['org_id'];
//	$user_client = $userdata['client_id'];
//	$user_org_id = get_organization_id($mycon, $user_client, $user_location);
//	$role_item = " AND tu.organization_id IN (" . $user_org_id . ")";
//	$loc_item = " AND loc_code = '" . $user_location . "' AND cust_code IN (" . $client_ids . ")";
//  } else {
//	$role_item = '';
//	$loc_item = '';
//	$user_org_id = '';
//  }
//echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
  ?>
  <p class="details_table">
	  <?php
	  if ($_POST['item'] == '') {
		$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
		if ($is_defaultshowEntries > 20) {
		  $defaultshowEntries = 20;
		} else {
		  $defaultshowEntries = $is_defaultshowEntries;
		}
		?>
		<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
	  <?php } else { ?>
		<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
	  <?php } ?>
  </p>
  <table class="table table-striped table-bordered table-hover" id="sample_3">
  	<thead>
  		<tr class="poke">
  			<th>Line and Station Code</th>
  			<th>Line and Station Name</th>
  			<th>Company Name</th>
  			<th>Address</th>
  			<th>Phone No.</th>
  			<th>E-Mail</th>
  			<th>Country</th>
  			<th>State</th>
  			<th>City</th>
  			<th>Region </th>
  			<th>Pin Code </th>
  			<!-- <th>Status</th> -->
  			<th>Action Item </th>
  		</tr>
  	</thead>
  	<tbody>

		  <?php
		  //get total number of records from database for pagination
		  $i = 1;
		  $sql_query = "SELECT * FROM `customer_details` WHERE customer_status != 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " AND uploaded_confirmed= '0' AND `type`= '2' order by customer_id DESC";

		  $result123 = mysqli_query($mycon, $sql_query);
		  $get_total_rows = mysqli_num_rows($result123);
		  $total_pages = ceil($get_total_rows / $item_per_page);


//get starting position to fetch the records
		  $page_position = (($page_number - 1) * $item_per_page);

		  $sql_query_fetch = "SELECT * FROM `customer_details` WHERE customer_status != 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " AND uploaded_confirmed= '0' AND `type`= '2' order by customer_id DESC LIMIT $page_position, $item_per_page";

		  $result_fetch = mysqli_query($mycon, $sql_query_fetch);
		  //echo '<br/>' . $sql_query_fetch;
		  //echo '<br/>' . $sql_query;
		  if (mysqli_num_rows($result_fetch) > 0) {
			while ($row = mysqli_fetch_assoc($result_fetch)) {
			  ?>
	  		<tr>
	  			<td> <?php echo $row['customer_code']; ?> </td>
	  			<td><?php echo $row['customer_name']; ?></td>
	  			<td><?php echo $row['company_name']; ?></td>
	  			<td> <?php echo $row['address1'] . "" . $row['address2']; ?> </td>
	  			<td> <?php echo $row['phone_number']; ?> </td>
	  			<td> <?php echo $row['email']; ?> </td>
	  			<td> <?php echo $row['country']; ?> </td>
	  			<td> <?php echo get_state_name($mycon, $row['state']); ?> </td>
	  			<td> <?php echo get_city_name($mycon, $row['city']); ?> </td>
	  			<td> <?php
					  if ($row['region'] != '0') {
						echo $row['region'];
					  } else {
						echo 'NA';
					  }
					  ?> </td>
	  			<td> <?php echo $row['pincode']; ?> </td>
	  			<!-- <td> <?php // echo $row['customer_status']==1 ? "Active" : "In Active" ; ?> </td> -->
	  			<td>

	  				<a href="line_n_station_master.php?d_id=<?php echo $row['customer_id'] ?>&edit=1"><span data-tooltip title="view" class="cursor"><i class="fa fa-eye" aria-hidden="true" style=""></i></span></a>



	  				<a href="line_n_station_master.php?d_id=<?php echo $row['customer_id'] ?>&edit=0"><span data-tooltip title="Edit" class="cursor"><i class="fa fa-pencil-square-o" aria-hidden="true" style=""></i></span></a>

	  				<a onclick="return confirm('Are you sure?')" href="line_n_station_master_listing.php?d_id=<?php echo $row['customer_id'] ?>"><span data-tooltip title="Delete" class="cursor"><i class="fa fa-trash" aria-hidden="true" style=""></i></span></a>
	  			</td>
	  		</tr>
			  <?php
			  $cnt++;
			}
		  } else {
			?>
			<tr>
				<td><?php echo 'No Record Found'; ?></td>
			</tr>
		  <?php } ?>
  	</tbody>
  </table>
  <div align="center">
	  <?php
	  /* We call the pagination function here to generate Pagination link for us.
	    As you can see I have passed several parameters to the function. */
	  echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
	  ?>
  </div>
  <?php
}
?>
</div>

