<?php

require_once '../init.php';

// Determine financial year dynamically
$current_year = date('Y');
$current_month = date('m');

if ($current_month <= 3) {
    $financial_year_start = $current_year - 1;
    $financial_year_end = $current_year;
} else {
    $financial_year_start = $current_year;
    $financial_year_end = $current_year + 1;
}

// Format financial year as "25-26"
$financial_year_suffix = substr($financial_year_start, -2) . '-' . substr($financial_year_end, -2);

// SQL Query to get the last invoice number of the current financial year
$sql_query = "SELECT invoice_number 
              FROM `order_management` 
              WHERE invoice_number LIKE 'GVL/%/$financial_year_suffix' 
              ORDER BY CAST(SUBSTRING_INDEX(SUBSTRING_INDEX(invoice_number, '/', -2), '/', 1) AS UNSIGNED) DESC 
              LIMIT 1";

$result = mysqli_query($mycon, $sql_query);

if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $invoice_number = $row['invoice_number'];
} else {
    // If no records exist, start from 1
    $invoice_number = "GVL/00000/$financial_year_suffix";
}

// Extract sequence number correctly
$ref_number_parts = explode('/', $invoice_number);

// Ensure correct parsing of sequence number
if (isset($ref_number_parts[1]) && is_numeric($ref_number_parts[1])) {
    $seqno = intval($ref_number_parts[1]) + 1;
} else {
    $seqno = 1;
}
$seqorderNum = str_pad($seqno, 5, '0', STR_PAD_LEFT);
$seqorderNo = "{$seqorderNum}";

$newgeneratedOrderno = 'GVL/' . $seqorderNo . '/' . $financial_year_suffix;


$order_id = $_GET['order_id'];
$mode = $_GET['mode'];


?>


<div class="modal-content" style="margin-top:12em;" id="manual_add_invoice">
    <div class="modal-header">
        <h3 class="modal-title" id="myModal123">Dispatch Challan/Invoice Detail</h3>
        <i class="fa fa-times" data-dismiss="modal" aria-hidden="true"></i>
        <i class="fa fa-cog" onclick="set_invoice_details_editable();" aria-hidden="true" style="display: none;" id="setting_edit"></i>
        <!-- <?php if ($mode == 2) { ?> <i class="fa fa-cog" onclick="set_invoice_details_editable();" aria-hidden="true" style="display: none;" id="setting_edit"></i> -->
        <!-- <?php } ?> -->
    </div>
    <div class="modal-body">
        <div class="col-md-6">
            <div class="form-group form-md-line-input form-md-floating-label has-success">
                <label for="form_control_1">Challan/Invoice Number</label>
                <input type="text" id="invoive_number" name="invoive_number" value="<?php echo $newgeneratedOrderno; ?>" class="form-control" id="form_control_1">

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group form-md-line-input form-md-floating-label has-success">
                <label for="form_control_1">Challan/Invoice Date</label>
                <input id="invoice_date" name="invoice_date" type="date" class="form-control" id="form_control_1" value="<?php echo date("Y-m-d");  ?>">

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group form-md-line-input form-md-floating-label has-success">
                <label for="form_control_1">E-way Bill Number </label>
                <input id="ebill_date_one" name="ebill_date_one" type="text" class="form-control" value="<?php echo "SLL-" . date("Ymd") . "" . time(); ?>" id="form_control_1">

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group form-md-line-input form-md-floating-label has-success">
                <label for="form_control_1">E-way bill Date</label>
                <input id="ebill_date_two" name="ebill_date_two" type="date" class="form-control" id="form_control_1" value="<?php echo date("Y-m-d");  ?>">

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group form-md-line-input form-md-floating-label has-success">
                <label for="form_control_1">PO Number</label>
                <input type="text" id="po_no" name="po_no" class="form-control" id="form_control_1" value="<?php echo time();  ?>">

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group form-md-line-input form-md-floating-label has-success">
                <label for="form_control_1">PO Date</label>
                <input id="po_date" name="po_date" value="<?php echo date("Y-m-d");  ?>" type="date" class="form-control" id="form_control_1">

            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group form-md-line-input form-md-floating-label has-success">
                <label for="form_control_1">Delivery Date</label>
                <input id="deliv_date" name="deliv_date" value="<?php echo date("Y-m-d");  ?>" type="date" class="form-control" id="form_control_1">
            </div>
        </div>
        <input id="mode" name="mode" type="hidden" value="" class="form-control">

    </div>
    <div class="modal-footer">
        <button style="margin: 26px 17px;" onclick="get_auto_invoice_details();" type="button" id="auto_gen" name="auto_gen" class="btn btn-info">Auto Genrate</button>
        <!-- <input id="auto_gen1" name="auto_gen" type="hidden" class="form-control"> -->


        <button style="margin: 26px 17px;" onclick="save_invoice_data(invoive_number, invoice_date, ebill_date_one, ebill_date_two)" type="button" class="btn btn-info">Save</button> <input id="auto_oder_id" name="auto_oder_id" value="<?php echo $order_id; ?>" type="hidden" class="form-control">

    </div>


</div>