<?php
// if (!empty($_GET['crate_ids'])) {
//     $ids = explode(',', $_GET['crate_ids']);
//     foreach ($ids as $id) {
//         echo "<p>QR for Crate ID: $id</p>";
//         echo "<img src='https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=$id' alt='QR for $id'><br><br>";
//     }
// }

if (!empty($_GET['crate_ids'])) {
    $ids = explode(',', $_GET['crate_ids']);
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>Print QR Codes</title>
    <style>
        @page {
            size: 50mm 50mm;
            margin: 0;
        }

        body {
            margin: 0;
            padding: 0;
            text-align: center;
            font-family: Arial, sans-serif;
        }

        .label {
            width: 50mm;
            height: 49mm;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            page-break-after: always;
            /* Uncomment this for testing alignment:
            border: 1px solid #000; */
        }

        img {
            width: 50mm;
            height: 35mm;
        }

        h3 {
            margin: 3mm 0 0;
            font-size: 6mm;
        }
    </style>
</head>

<body onload="window.print()">
    <?php if (!empty($ids)): ?>
        <?php foreach ($ids as $id): ?>
            <div class="label">
                <img src="https://api.qrserver.com/v1/create-qr-code/?size=600x400&data=<?php echo urlencode($id); ?>" alt="QR for <?php echo htmlspecialchars($id); ?>">
                <h3><?php echo htmlspecialchars($id); ?></h3>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No crate IDs selected.</p>
    <?php endif; ?>
</body>

</html>