<?php
require_once '../init.php';
include_once 'validate_input_funtion_special_chars_non_numbers.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
    exit;
}

$today = date('Y-m-d');

function IsFoundCustomerCode($customer_code, $mycon)
{
    $query = "SELECT 1 FROM customer_details WHERE customer_code = '$customer_code' LIMIT 1";
    $result = mysqli_query($mycon, $query);
    return (mysqli_num_rows($result) > 0);
}


function GetCorrectUOM($UnitOfMeasurement, $mycon)
{
    $UnitOfMeasurement = trim($UnitOfMeasurement);
    $UnitOfMeasurement = mysqli_real_escape_string($mycon, $UnitOfMeasurement);

    $sql_query = "SELECT actual_uom FROM uom_master_tbl WHERE FIND_IN_SET('$UnitOfMeasurement', uom) LIMIT 1";
    $result = mysqli_query($mycon, $sql_query);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        return $row['actual_uom'];
    } else {
        return '';
    }
}

function GetWMSProductMasterCode($ProductCode, $mycon)
{
    $ProductCode = trim($ProductCode);
    $ProductCode = mysqli_real_escape_string($mycon, $ProductCode);

    $sql_query = "SELECT gnosispc FROM customer_product_master_tbl WHERE code_ril = '" . $ProductCode . "' LIMIT 1";
    $result = mysqli_query($mycon, $sql_query);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        return $row['gnosispc'];
    } else {
        return $ProductCode;
    }
}

// function isDuplicateDayEntry($customer_code, $ProductCode, $day_column, $mycon)
// {
//     $today = date('Y-m-d');
//     $query = "SELECT 1 FROM bulk_order_data_tbl WHERE customer_code = '$customer_code' AND code = '$ProductCode'  AND crate_order_date = '$today' AND $day_column <> '' LIMIT 1";
//     $result = mysqli_query($mycon, $query);
//     return (mysqli_num_rows($result) > 0);
// }

// --- File Upload Handling ---
if (!empty($_FILES["excel_file"])) {

    $file_array = explode(".", $_FILES["excel_file"]["name"]);
    if ($file_array[1] == "xls" || $file_array[1] == "xlsx") {

        include("PHPExcel/Classes/PHPExcel/IOFactory.php");

        $output = '';
        $output .= "
        <label class='text-success'>Data Inserted</label>
        <div style='overflow-x:scroll'>
            <table class='table table-sm table-nowrap table-bordered card-table'>
                <thead>
                    <tr>
                        <th>Customer Code</th>
                        <th>Code</th>
                        <th>Item Category</th>
                        <th>Item Type</th>
                        <th>Item Name</th>
                        <th>Location</th>
                        <th>UOM</th>
                        <th>Kitchen Area</th>
                        <th>Mon</th>
                        <th>Tue</th>
                        <th>Wed</th>
                        <th>Thu</th>
                        <th>Fri</th>
                        <th>Sat</th>
                        <th>Sun</th>
                        <th>File Reff No</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>";

        $object = PHPExcel_IOFactory::load($_FILES["excel_file"]["tmp_name"]);
        $worksheet = $object->getSheet(0);
        $highestRow = $worksheet->getHighestRow();

        $i = $j = $k = 0;

        // --- Validate headers ---
        $expected_headers = ['Customer Code', 'Code', 'Item Category', 'Item type', 'Item Name', 'Location', 'UOM', 'Kitchen Area', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun', 'Reference No'];

        for ($col = 0; $col < count($expected_headers); $col++) {
            $header_value = trim($worksheet->getCellByColumnAndRow($col, 2)->getValue());
            if ($header_value !== $expected_headers[$col]) {
                die('EXCEL header mismatch at column ' . ($col + 1) . '. Expected "' . $expected_headers[$col] . '" but found "' . $header_value . '".');
            }
        }

        // --- Read data rows ---
        for ($row = 3; $row <= $highestRow; $row++) {

            $customer_code = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(0, $row)->getValue());
            $code = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(1, $row)->getValue());
            $item_category = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(2, $row)->getValue());
            $item_type = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(3, $row)->getValue());
            $item_name = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(4, $row)->getValue());
            $location = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(5, $row)->getValue());
            $uom = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(6, $row)->getValue());
            $kitchen_area = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(7, $row)->getValue());
            $monday = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(8, $row)->getValue());
            $tuesday = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(9, $row)->getValue());
            $wednesday = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(10, $row)->getValue());
            $thursday = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(11, $row)->getValue());
            $friday = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(12, $row)->getValue());
            $saturday = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(13, $row)->getValue());
            $sunday = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(14, $row)->getValue());
            $ReferenceNo = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(15, $row)->getValue());

            if (!empty($ReferenceNo)) {
                $checkRefSQL = "SELECT 1 FROM bulk_order_data_tbl WHERE file_ref_num = '$ReferenceNo' AND uploaded_confirmed = '0'";
                $checkRefRes = mysqli_query($mycon, $checkRefSQL);

                if (mysqli_num_rows($checkRefRes) > 0) {
                    die("<span style='color:red;font-weight:bold;'>This File Reference No ($ReferenceNo) already uploaded.</span>");
                }
            }

            if (empty($customer_code) || empty($code)) continue;

            $CorrectedUOM = GetCorrectUOM($uom, $mycon);
            $ProductCode = GetWMSProductMasterCode($code, $mycon);
            $IsFoundCoustomerCode = IsFoundCustomerCode($customer_code, $mycon);

            // --- Check duplicate day-wise ---
            // $duplicateFound = false;
            // $duplicateDays = [];

            // $dayColumns = [
            //     'monday' => $monday,
            //     'tuesday' => $tuesday,
            //     'wednesday' => $wednesday,
            //     'thursday' => $thursday,
            //     'friday' => $friday,
            //     'saturday' => $saturday,
            //     'sunday' => $sunday
            // ];

            // foreach ($dayColumns as $dayCol => $value) {
            //     if (!empty($value) && isDuplicateDayEntry($customer_code, $ProductCode, $dayCol, $mycon)) {
            //         $duplicateFound = true;
            //         $duplicateDays[] = ucfirst($dayCol);
            //     }
            // }

            if (!$IsFoundCoustomerCode) {
                $output .= "
                <tr style='color:red'>
                    <td>$customer_code</td>
                    <td>$code</td>
                    <td>$item_category</td>
                    <td>$item_type</td>
                    <td>$item_name</td>
                    <td>$location</td>
                    <td>$uom</td>
                    <td>$kitchen_area</td>
                    <td>$monday</td>
                    <td>$tuesday</td>
                    <td>$wednesday</td>
                    <td>$thursday</td>
                    <td>$friday</td>
                    <td>$saturday</td>
                    <td>$sunday</td>
                    <td>$ReferenceNo</td>
                    <td>Not Uploaded (Customer not found)</td>
                </tr>";
                $j++;
                continue;
            } else {
                $query = "INSERT INTO bulk_order_data_tbl (user_id, warehouse_id, customer_code, code, item_category, item_type, item_name, location, uom, kitchen_area, actual_uom, monday, tuesday, wednesday, thursday, friday, saturday, sunday, crate_order_date, file_ref_num, uploaded_confirmed, created_at, updated_at)
                VALUES ('$userid', '$warehouse_id', '$customer_code', '$ProductCode', '$item_category', '$item_type', '$item_name', '$location', '$uom', '$kitchen_area', '$CorrectedUOM', '$monday', '$tuesday', '$wednesday', '$thursday', '$friday', '$saturday', '$sunday', '$today', '$ReferenceNo', 1, NOW(), NOW())";

                $insert_data = mysqli_query($mycon, $query);

                if (!$insert_data) {
                    $output .= '<tr><td colspan="17">MySQL Error: ' . mysqli_error($mycon) . '</td></tr>';
                } else {
                    $output .= "
                    <tr>
                        <td>$customer_code</td>
                        <td>$code</td>
                        <td>$item_category</td>
                        <td>$item_type</td>
                        <td>$item_name</td>
                        <td>$location</td>
                        <td>$uom</td>
                        <td>$kitchen_area</td>
                        <td>$monday</td>
                        <td>$tuesday</td>
                        <td>$wednesday</td>
                        <td>$thursday</td>
                        <td>$friday</td>
                        <td>$saturday</td>
                        <td>$sunday</td>
                        <td>$ReferenceNo</td>
                        <td>Uploaded</td>
                    </tr>";
                    $k++;
                }
            }

            $i++;
        }

        $output .= '</tbody></table></div>';
        $data_uploaded = "<b>Total Data:</b> $i | <b>Uploaded:</b> $k | <b>Duplicates:</b> $j<br/>";
        echo $data_uploaded . "<br/>" . $output;
    } else {
        echo '<label class="text-danger">Invalid File Format. Please upload .xls or .xlsx file.</label>';
    }
}
