<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
   header('location: ../index.php');
}

$type = "2";

$sql_query_custo = "SELECT * FROM barqr_customization WHERE type= 2 ";
$result_custo = mysqli_query($mycon, $sql_query_custo);
if (mysqli_num_rows($result_custo) > 0) {
   while ($row_custo = mysqli_fetch_assoc($result_custo)) {
      //print_r($row); 
      $type = $row_custo['type'];
      $is_batchcode = $row_custo['batchcode'];
      $is_product_code = $row_custo['product_code'];
      $is_lot_no = $row_custo['lot_no'];
      $is_product_color = $row_custo['product_color'];
      $is_mfg_date = $row_custo['mfg_date'];
      $is_expiry_date = $row_custo['expiry_date'];
      $is_moq = $row_custo['moq'];
      $is_vendor_name = $row_custo['vendor_name'];
      $is_transporter_name = $row_custo['transporter_name'];
      $is_inward_date = $row_custo['inward_date'];
      $is_size = $row_custo['size'];
      $is_unit_price = $row_custo['unit_price'];
      $is_product_desc = $row_custo['product_desc'];

      $is_product = $row_custo['product'];
      $is_datetime = $row_custo['created_at'];
      $is_month = $row_custo['month'];
      $is_date = $row_custo['date'];
      $is_year = $row_custo['year'];
      $is_serial_no_length = $row_custo['serial_no_length'];


      // echo $is_product; die;
   }
}

?>

<!DOCTYPE html>
<html lang="en">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
   <meta charset="utf-8" />
   <title><?php echo $header_project_name; ?></title>
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta content="width=device-width, initial-scale=1" name="viewport" />
   <meta content="<?php echo $wmsData['about_wh']; ?>" name="description" />
   <meta content="Vikas Singh" name="author" />
   <link href="css/tooltip.css" rel="stylesheet" type="text/css">
   <link rel="stylesheet" href="css/style.css">
   <style type="text/css">
      .boxes {
         margin: auto;
         padding: 50px;
      }

      /*Checkboxes styles*/
      input[type="checkbox"] {
         display: none;
      }

      input[type="checkbox"]+label {
         display: block;
         position: relative;
         padding-left: 35px;
         margin-bottom: 20px;
         font: 14px/20px 'Open Sans', Arial, sans-serif;
         /*color: #ddd;*/
         cursor: pointer;
         -webkit-user-select: none;
         -moz-user-select: none;
         -ms-user-select: none;
      }

      input[type="checkbox"]+label:last-child {
         margin-bottom: 0;
      }

      input[type="checkbox"]+label:before {
         content: '';
         display: block;
         width: 20px;
         height: 20px;
         border: 1px solid #006229;
         position: absolute;
         left: 0;
         top: 0;
         opacity: .6;
         -webkit-transition: all .12s, border-color .08s;
         transition: all .12s, border-color .08s;
      }

      input[type="checkbox"]:checked+label:before {
         width: 10px;
         top: -5px;
         left: 5px;
         border-radius: 0;
         opacity: 1;
         border-top-color: transparent;
         border-left-color: transparent;
         -webkit-transform: rotate(45deg);
         transform: rotate(45deg);
      }
   </style>


</head>
<!-- END HEAD -->
<?php include 'shared/header.php'; ?>

<body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white page-sidebar-closed page-md">
   <div class="page-wrapper">
      <?php include 'top_menu.php'; ?>
      <!-- END HEADER -->
      <!-- BEGIN HEADER & CONTENT DIVIDER -->
      <div class="clearfix"> </div>
      <!-- END HEADER & CONTENT DIVIDER -->
      <!-- BEGIN CONTAINER -->
      <div class="page-container">
         <?php include 'sidebar.php'; ?>
         <!-- BEGIN CONTENT -->
         <div class="page-content-wrapper">
            <!-- BEGIN CONTENT BODY -->
            <div class="page-content">
               <!-- <div id="overlay">
                     <div id="progstat"></div>
                     <div id="progress"></div>
                     </div> -->
               <div style="display:none;" id="container">
                  <img src="http://placehold.it/3000x3000/cf5">
               </div>
               <div class="col-md-12">
                  <!-- Begin: life time stats -->
                  <div class="portlet light portlet-fit portlet-datatable bordered">
                     <div class="portlet-title">
                        <div class="row">
                           <div class="col-md-8 table_header">
                              <!-- <h3>QR Code Details</h3> -->
                              <div class="tabbable-line">
                                 <ul class="nav nav-tabs nav-tabs-lg">
                                    <li><a href="barcode_qrcode_customization.php">QR Code Sticker (Size-180*30)</a></li>
                                    <li class="active"><a href="barcode_100_50_customization.php">Barcode Sticker (Size-100*50)</a></li>
                                    <li><a href="barcode_75_35_customization.php">Barcode Sticker (Size-75*35)</a></li>

                                    <li><a href="picklist_print_setting.php">Order Picklist Print Setting</a></li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-md-12">
                  <h3 class="table_header" style="color:#1fac8b">Barcode (Size-100*50) Customization</h3>
                  <form action="" method="post" enctype="multipart/form-data">
                     <div class="row">
                        <div class="col-md-4">
                           <div class="boxes">
                              <input type="hidden" id="id_barcode_100" name="id_barcode_100" class="form-control">
                              <input type="checkbox" id="product_code" class="single-checkbox" <?php echo $is_product_code ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="product_code">Product Code</label>
                              <input type="checkbox" id="product_desc" class="single-checkbox" <?php echo $is_product_desc ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="product_desc">Product Description</label>
                              <input type="checkbox" id="product_color" class="single-checkbox" <?php echo $is_product_color ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="product_color">Product Color</label>
                              <input type="checkbox" id="batchcode" class="single-checkbox" <?php echo $is_batchcode ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="batchcode">Batch Code</label>

                              <input type="checkbox" id="unit_price" class="single-checkbox" <?php echo $is_unit_price ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="unit_price">Price</label>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="boxes">
                              <input type="checkbox" id="lot_no" class="single-checkbox" <?php echo $is_lot_no ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="lot_no">Lot. No</label>
                              <input type="checkbox" id="mfg_date" class="single-checkbox" <?php echo $is_mfg_date ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="mfg_date">Mfg. date</label>
                              <input type="checkbox" id="expiry_date" class="single-checkbox" <?php echo $is_expiry_date ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="expiry_date">Expiry Date</label>
                              <input type="checkbox" id="moq" class="single-checkbox" <?php echo $is_moq ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="moq">Moq</label>


                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="boxes">
                              <input type="checkbox" id="vendor_name" class="single-checkbox" <?php echo $is_vendor_name ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="vendor_name">Supplier Name </label>

                              <input type="checkbox" id="transporter_name" class="single-checkbox" <?php echo $is_transporter_name ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="transporter_name ">Transporter Name</label>

                              <input type="checkbox" id="inward_date" class="single-checkbox" <?php echo $is_inward_date ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="inward_date">Inward date</label>

                              <input type="checkbox" id="size" class="single-checkbox" <?php echo $is_size ? 'checked' : '' ?> value="<?php echo  '1'; ?>">
                              <label for="size">Size</label>
                           </div>
                        </div>
                        <div class="col-md-12">
                           <h3 class="table_header" style="color:#1fac8b">Barcode Output Rules</h3>
                           <div class="boxes">
                              <div class="row">

                                 <div class="col-md-2">
                                    <label style="font-size:18px; font-weight:bold; float:right;">Product :</label>
                                 </div>
                                 <div class="col-md-10">
                                    <input type="checkbox" id="product" <?php echo $is_product ? 'checked' : '' ?> value="<?php echo '1'; ?>">
                                    <label for="product">Product Code</label>
                                 </div>
                              </div>
                              <div class="row">

                                 <div class="col-md-2">
                                    <label style="font-size:18px; font-weight:bold; float:right;">Date :</label>
                                 </div>
                                 <div class="col-md-2">
                                    <input type="checkbox" id="created_at" <?php echo $is_datetime ? 'checked' : '' ?> value="<?php echo '1'; ?>">
                                    <label for="created_at">Date & Time</label>

                                 </div>
                                 <div class="col-md-1">
                                    <div class="vl" style="border-left:3px solid green; height:30px;"></div>

                                 </div>
                                 <div class="col-md-1">
                                    <input type="checkbox" id="date" <?php echo $is_date ? 'checked' : '' ?> value="<?php echo '1'; ?>">
                                    <label for="date">Date</label>

                                 </div>
                                 <div class="col-md-1">
                                    <input type="checkbox" id="month" <?php echo $is_month ? 'checked' : '' ?> value="<?php echo '1'; ?>">
                                    <label for="month">Month</label>

                                 </div>
                                 <div class="col-md-1">
                                    <input type="checkbox" id="year" <?php echo $is_year ? 'checked' : '' ?> value="<?php echo '1'; ?>">
                                    <label for="year">Year</label>

                                 </div>
                              </div>
                              <div class="row">

                                 <div class="col-md-2">
                                    <label style="font-size:18px; font-weight:bold; margin-left: 14px;">Fix Serial No Length :</label>
                                 </div>
                                 <div class="col-md-10">
                                    <input type="number" min="2" max="8" id="serial_no_length" value="<?php echo  $is_serial_no_length; ?>" class="form-control" style="width:150px;">

                                 </div>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-12">
                           <button class="btn btn-success" onclick="save_to_server(event)" style="margin-left:50px;">Submit</button>
                        </div>
                     </div><br>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   <!--******* footer start*******-->
   <footer class="global_footer">
      <div class="container-fluid">
         <div class="row" style="overflow: hidden;">
            <div class="col-sm-6  footer_copy_logo clearfix">
               Copyright 2019-<?php echo date('Y'); ?> | Design & Develop By <?php echo $header_project_name; ?>
            </div>
            <div class="logo_foot col-md-6 text-right">
               <a href="#"><img src="../assets/layouts/layout/img/logo.png" alt="logo" class="logo-default" style="max-width: 145px;object-fit: cover;"></a>
            </div>
         </div>
      </div>
   </footer>



   <script type="text/javascript">
      $('.single-checkbox').on('change', function() {
         if ($('.single-checkbox:checked').length > 9) {
            this.checked = alert('You Can Choose Max 9 Check Boxes for Barcode (Size-100*50) Customization ');
         }
      });
   </script>
   <!--******* footer end *******-->
   <?php include 'shared/footer.php'; ?>
   </div>

   <script type="text/javascript">
      function save_to_server(event) {
         event.preventDefault();

         var product_code = $('#product_code').is(':checked') ? document.getElementById('product_code').value : '';
         product_code = window.escape(product_code);


         var product_desc = $('#product_desc').is(':checked') ? document.getElementById('product_desc').value : '';
         product_desc = window.escape(product_desc);

         var product_color = $('#product_color').is(':checked') ? document.getElementById('product_color').value : '';
         product_color = window.escape(product_color);

         var batchcode = $('#batchcode').is(':checked') ? document.getElementById('batchcode').value : '';
         batchcode = window.escape(batchcode);

         var lot_no = $('#lot_no').is(':checked') ? document.getElementById('lot_no').value : '';
         lot_no = window.escape(lot_no);

         var mfg_date = $('#mfg_date').is(':checked') ? document.getElementById('mfg_date').value : '';
         mfg_date = window.escape(mfg_date);

         var expiry_date = $('#expiry_date').is(':checked') ? document.getElementById('expiry_date').value : '';
         expiry_date = window.escape(expiry_date);

         var moq = $('#moq').is(':checked') ? document.getElementById('moq').value : '';
         moq = window.escape(moq);



         var vendor_name = $('#vendor_name').is(':checked') ? document.getElementById('vendor_name').value : '';
         vendor_name = window.escape(vendor_name);

         var transporter_name = $('#transporter_name').is(':checked') ? document.getElementById('transporter_name').value : '';
         transporter_name = window.escape(transporter_name);

         var inward_date = $('#inward_date').is(':checked') ? document.getElementById('inward_date').value : '';
         inward_date = window.escape(inward_date);

         var size = $('#size').is(':checked') ? document.getElementById('size').value : '';
         size = window.escape(size);

         var unit_price = $('#unit_price').is(':checked') ? document.getElementById('unit_price').value : '';
         unit_price = window.escape(unit_price);

         var created_at = $('#created_at').is(':checked') ? document.getElementById('created_at').value : '';
         created_at = window.escape(created_at);

         var product = $('#product').is(':checked') ? document.getElementById('product').value : '';
         product = window.escape(product);
         var date = $('#date').is(':checked') ? document.getElementById('date').value : '';
         date = window.escape(date);
         var month = $('#month').is(':checked') ? document.getElementById('month').value : '';
         month = window.escape(month);

         var year = $('#year').is(':checked') ? document.getElementById('year').value : '';
         year = window.escape(year);

         var serial_no_length = document.getElementById('serial_no_length').value;
         serial_no_length = window.escape(serial_no_length);

         var id_barcode_100 = document.getElementById('id_barcode_100').value;
         id_barcode_100 = window.escape(id_barcode_100);



         if (product == "") {
            alert("Kindly Choose Product Code");
         } else if (serial_no_length == "") {
            alert("Kindly Enter  Serial No Length");
         } else {


            urll = "send_barcode_100_50_data.php?data=" + product_code + "~" + product_desc + "~" + product_color + "~" + batchcode + "~" + lot_no + "~" + mfg_date + "~" + expiry_date + "~" + moq + "~" + vendor_name + "~" + transporter_name + "~" + inward_date + "~" + size + "~" + unit_price + "~" + created_at + "~" + product + "~" + date + "~" + month + "~" + year + "~" + serial_no_length + "~" + id_barcode_100;

            //console.log(urll);return false;
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
               if (this.readyState == 4 && this.status == 200) {

                  console.log(this.responseText);

                  if (this.responseText == 1) {
                     alert('Done');
                     //cutomer_master_listing.php
                     window.location = "barcode_100_50_customization.php";
                  } else if (this.responseText == 4) {
                     alert('Duplicate Entry..');
                  } else {
                     alert('Something Went Wrong..');
                  }
               }
            };
            xhttp.open("GET", urll, true);
            xhttp.send();
            return false;
         }
      }
   </script>